require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Butchering"

local greyedout = {
    gap = true,
    color = ST.COLORS.greyedout,
} 

ST.addContributor(KEY, function(ctx)
    local lvl = ctx.getLevel()

    -- Quantity ceiling multiplier (affects the max rollable pieces)
    -- Derived from vanilla behavior: +0.1 every 2 levels → 1.0 .. 1.5
    local qtyMult = 1.0 + (math.floor(lvl / 2) * 0.1)

    -- Quality roll weight multiplier (pushes toward higher-tier cuts)
    -- Approx: level / 7.0 → 0.00 .. ~1.4286 at level 10
    local qualMult = lvl / 7.0

    -- Format to two decimals (avoid trailing scientific notation, etc.)
    local function _fmt2(x)
        -- Keep at least two decimals; clamp very small negatives to 0
        if x < 0 and x > -0.005 then x = 0 end
        return string.format("%.2f", x)
    end
    
    ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))
    ctx.add(ST.getText("IGUI_DST_Butchering_val_Quantity", _fmt2(qtyMult)))
    ctx.add(ST.getText("IGUI_DST_Butchering_val_Quality", _fmt2(qualMult)))

    ctx.add(ST.getText("IGUI_DST_Butchering_val_Hint"), greyedout)
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)